
//
// To jest przykadowy kod z podrozdziau 9.4.6 Raportowanie bdw ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>

using namespace std;

//------------------------------------------------------------------------------

// Prosta klasa Date (uniemoliwia tworzenie obiektw o nieprawidowym stanie).
class Date {
public:
    class Invalid { };         // Bdzie suy jako typ wyjtku.
    Date(int y, int m, int d); // Sprawdza poprawno daty i wykonuje inicjacj.
    int month() { return m; }
    int day()   { return d; }
    int year()  { return y; }
    void add_day(int n) { /*...*/ }

private:
    int y, m, d;               // Rok, miesic, dzie
    bool check();              // Zwraca true, jeli data jest poprawna.
};

//------------------------------------------------------------------------------

Date::Date(int yy, int mm, int dd)
: y(yy), m(mm), d(dd)              // Inicjacja danych skadowych.
{
    if (!check()) throw Invalid(); // Sprawdzanie poprawnoci.
}

//------------------------------------------------------------------------------

bool Date::check()  // Zwraca true, jeli data jest poprawna.
{
    if (m<1 || 12<m) return false;
    // ...
}

//------------------------------------------------------------------------------

ostream& operator<<(ostream& os, Date& d)
{
    return os << '(' << d.year() << ',' << d.month() << ',' << d.day() << ')';
}

//------------------------------------------------------------------------------

void error(const char* errmsg)
{
    cerr << errmsg << endl;
}

//------------------------------------------------------------------------------

void f(int x, int y)
try {
    Date dxy(2004,x,y);
    cout << dxy << '\n';       // Deklaracja operatora << znajduje si w podrozdziale 9.8.
    dxy.add_day(2);
}
catch(Date::Invalid) {
    error("Nieprawidowa data");
}

//------------------------------------------------------------------------------

int main()
try
{
    f(8,29);
    f(15,29);                  // Bd czasu wykonywania: nieprawidowa data.
    return 0;
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
